/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.entity;

import dev.toma.gunsrpg.common.entity.projectile.EffectSpreadReaction;
import dev.toma.gunsrpg.common.entity.projectile.ExplosiveReaction;
import dev.toma.gunsrpg.common.entity.projectile.IReaction;
import dev.toma.gunsrpg.common.entity.projectile.MultipartReaction;
import dev.toma.gunsrpg.common.entity.projectile.NapalmReaction;
import dev.toma.gunsrpg.common.entity.projectile.Rocket;
import dev.toma.gunsrpg.common.init.ModEntities;
import dev.toma.gunsrpg.util.math.WeightedRandom;
import dev.toma.gunsrpg.util.properties.Properties;
import java.util.EnumSet;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class RocketAngelEntity
extends MonsterEntity
implements IEntityAdditionalSpawnData {
    private Type type = (Type)((Object)Type.access$000().getRandom());

    public RocketAngelEntity(World world) {
        this((EntityType<? extends MonsterEntity>)((EntityType)ModEntities.ROCKET_ANGEL.get()), world);
    }

    public RocketAngelEntity(EntityType<? extends MonsterEntity> type, World world) {
        super(type, world);
        this.field_70728_aV = 8;
        this.field_70765_h = new MoveController(this);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return RocketAngelEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 45.0).func_233815_a_(Attributes.field_233823_f_, 4.0).func_233815_a_(Attributes.field_233819_b_, 96.0);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_189654_d(true);
    }

    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        return false;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new RocketAttack(this));
        this.field_70714_bg.func_75776_a(8, (Goal)new MoveRandom());
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    public int getTextureIndex() {
        return this.type.ordinal();
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_191264_hc;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_191266_he;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_191267_hf;
    }

    public float func_70013_c() {
        return this.type == Type.STUN ? 0.7f : 1.0f;
    }

    public boolean func_70652_k(Entity entityIn) {
        float f = (float)this.func_233637_b_(Attributes.field_233823_f_);
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), f);
        if (flag) {
            Vector3d look = this.func_70040_Z();
            Vector3d knockback = look.func_186678_a(3.0);
            entityIn.func_213293_j(knockback.field_72450_a, Math.abs(knockback.field_72448_b), knockback.field_72449_c);
        }
        return flag;
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.type);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.type = (Type)additionalData.func_179257_a(Type.class);
    }

    class MoveController
    extends MovementController {
        public MoveController(RocketAngelEntity angel) {
            super((MobEntity)angel);
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                double x = this.func_179917_d() - RocketAngelEntity.this.func_226277_ct_();
                double y = this.func_179919_e() - RocketAngelEntity.this.func_226278_cu_();
                double z = this.func_179918_f() - RocketAngelEntity.this.func_226281_cx_();
                double dist = x * x + y * y + z * z;
                if ((dist = (double)MathHelper.func_76133_a((double)dist)) < RocketAngelEntity.this.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = MovementController.Action.WAIT;
                    RocketAngelEntity.this.func_213317_d(RocketAngelEntity.this.func_213322_ci().func_186678_a(0.5));
                } else {
                    RocketAngelEntity.this.func_213317_d(RocketAngelEntity.this.func_213322_ci().func_72441_c(x / dist * 0.05 * this.field_75645_e, y / dist * 0.05 * this.field_75645_e, z / dist * 0.05 * this.field_75645_e));
                    if (RocketAngelEntity.this.func_70638_az() == null) {
                        Vector3d vector3d1 = RocketAngelEntity.this.func_213322_ci();
                        RocketAngelEntity.this.field_70177_z = -((float)MathHelper.func_181159_b((double)vector3d1.field_72450_a, (double)vector3d1.field_72449_c)) * 57.295776f;
                    } else {
                        double px = RocketAngelEntity.this.func_70638_az().func_226277_ct_() - RocketAngelEntity.this.func_226277_ct_();
                        double pz = RocketAngelEntity.this.func_70638_az().func_226281_cx_() - RocketAngelEntity.this.func_226281_cx_();
                        RocketAngelEntity.this.field_70177_z = -((float)MathHelper.func_181159_b((double)px, (double)pz)) * 57.295776f;
                    }
                    RocketAngelEntity.this.field_70761_aq = RocketAngelEntity.this.field_70177_z;
                }
            }
        }
    }

    class MoveRandom
    extends Goal {
        public MoveRandom() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return !RocketAngelEntity.this.func_70605_aq().func_75640_a() && RocketAngelEntity.this.field_70146_Z.nextInt(7) == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            BlockPos blockpos = RocketAngelEntity.this.func_226268_ag_();
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(RocketAngelEntity.this.field_70146_Z.nextInt(15) - 7, RocketAngelEntity.this.field_70146_Z.nextInt(11) - 5, RocketAngelEntity.this.field_70146_Z.nextInt(15) - 7);
                if (!RocketAngelEntity.this.field_70170_p.func_175623_d(blockpos1)) continue;
                RocketAngelEntity.this.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 0.25);
                if (RocketAngelEntity.this.func_70638_az() != null) break;
                RocketAngelEntity.this.func_70671_ap().func_75650_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    static class RocketAttack
    extends Goal {
        private final RocketAngelEntity entity;
        private int toFire;
        private int cooldown;

        public RocketAttack(RocketAngelEntity entity) {
            this.entity = entity;
            this.func_220684_a(EnumSet.of(Goal.Flag.TARGET, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity target = this.entity.func_70638_az();
            return target != null && target.func_70089_S();
        }

        public void func_75249_e() {
            this.toFire = 3;
            this.cooldown = 15;
        }

        public void func_75251_c() {
            this.cooldown = Integer.MAX_VALUE;
        }

        public void func_75246_d() {
            --this.cooldown;
            LivingEntity target = this.entity.func_70638_az();
            if (target == null) {
                return;
            }
            double distance = this.entity.func_70068_e((Entity)target);
            boolean canSee = this.entity.func_70635_at().func_75522_a((Entity)target);
            if (canSee) {
                if (distance < 4.0) {
                    if (this.cooldown <= 0) {
                        this.cooldown = 10;
                        this.entity.func_70652_k((Entity)target);
                    }
                } else if (distance < this.getFollowDistance() * this.getFollowDistance() / (double)1.1f) {
                    this.entity.func_70625_a((Entity)target, 30.0f, 30.0f);
                    this.entity.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
                    int heightDiff = (int)(this.entity.func_226278_cu_() - target.func_226278_cu_());
                    if (heightDiff < 10) {
                        Vector3d currentMovement = this.entity.func_213322_ci();
                        this.entity.func_213293_j(currentMovement.field_72450_a, 0.2, currentMovement.field_72449_c);
                    }
                    if (this.cooldown <= 0) {
                        this.cooldown = 6;
                        Difficulty difficulty = this.entity.field_70170_p.func_175659_aa();
                        Rocket rocket = new Rocket((EntityType<? extends Rocket>)((EntityType)ModEntities.ROCKET.get()), this.entity.field_70170_p, (LivingEntity)this.entity);
                        rocket.setup(0.0f, 2.0f, 0);
                        rocket.fire(this.entity.field_70125_A, this.entity.field_70177_z, 6.4f - (float)difficulty.func_151525_a() * 0.3f);
                        rocket.setProperty(Properties.FUELED, true);
                        rocket.setProperty(Properties.REACTION, this.entity.type.getReaction());
                        this.entity.field_70170_p.func_217376_c((Entity)rocket);
                        this.entity.field_70170_p.func_184148_a(null, this.entity.func_226277_ct_(), this.entity.func_226278_cu_(), this.entity.func_226281_cx_(), SoundEvents.field_187631_bo, SoundCategory.MASTER, 10.0f, 1.0f);
                        --this.toFire;
                        if (this.toFire < 0) {
                            this.toFire = 3;
                            this.cooldown = 100;
                        }
                    }
                } else {
                    this.entity.func_70661_as().func_75499_g();
                    this.entity.func_70605_aq().func_75642_a(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), 0.4);
                }
            } else {
                this.entity.func_70661_as().func_75499_g();
                this.entity.func_70605_aq().func_75642_a(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), 0.4);
            }
        }

        private double getFollowDistance() {
            double dist = this.entity.func_233637_b_(Attributes.field_233819_b_);
            return dist == 0.0 ? 16.0 : dist;
        }
    }

    static enum Type {
        STANDARD(35, 0xFFFF9B, new ExplosiveReaction(2.0f, Explosion.Mode.DESTROY)),
        HE(10, 6537471, new ExplosiveReaction(3.0f, Explosion.Mode.DESTROY)),
        INCENDIARY(8, 16746856, MultipartReaction.multi(new ExplosiveReaction(2.0f, Explosion.Mode.DESTROY), new NapalmReaction(3.0, 0.3f))),
        TOXIN(16, 12162047, MultipartReaction.multi(new ExplosiveReaction(2.0f, Explosion.Mode.NONE), new EffectSpreadReaction(12162047, () -> new EffectInstance(Effects.field_82731_v, 120, 1)))),
        STUN(12, 0xD3D3D3, MultipartReaction.multi(new ExplosiveReaction(2.0f, Explosion.Mode.NONE), new EffectSpreadReaction(0xD3D3D3, () -> new EffectInstance(Effects.field_76421_d, 80, 9))));

        private static final WeightedRandom<Type> SELECTOR;
        private final int weight;
        private final int color;
        private final IReaction reaction;

        private Type(int weight, int color, IReaction reaction) {
            this.weight = weight;
            this.color = color;
            this.reaction = reaction;
        }

        public int getWeight() {
            return this.weight;
        }

        public int getColor() {
            return this.color;
        }

        public IReaction getReaction() {
            return this.reaction;
        }

        static /* synthetic */ WeightedRandom access$000() {
            return SELECTOR;
        }

        static {
            SELECTOR = new WeightedRandom<Type>(Type::getWeight, Type.values());
        }
    }
}

